/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.entries.BlockClassEntry;
import com.rwtema.extrautils2.backend.entries.BlockCompressedEntry;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.ItemClassEntry;
import com.rwtema.extrautils2.backend.entries.ItemEnderShardEntry;
import com.rwtema.extrautils2.backend.entries.ItemEntry;
import com.rwtema.extrautils2.backend.entries.ItemEntrySickle;
import com.rwtema.extrautils2.backend.entries.MultiBlockEntry;
import com.rwtema.extrautils2.backend.entries.VoidEntry;
import com.rwtema.extrautils2.blocks.BlockAngelBlock;
import com.rwtema.extrautils2.blocks.BlockCursedEarth;
import com.rwtema.extrautils2.blocks.BlockDecorativeGlass;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolid;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolidWood;
import com.rwtema.extrautils2.blocks.BlockEnderLilly;
import com.rwtema.extrautils2.blocks.BlockMoonStone;
import com.rwtema.extrautils2.blocks.BlockPassiveGenerator;
import com.rwtema.extrautils2.blocks.BlockPlayerChest;
import com.rwtema.extrautils2.blocks.BlockPowerOverload;
import com.rwtema.extrautils2.blocks.BlockRedOrchid;
import com.rwtema.extrautils2.blocks.BlockRedstoneClock;
import com.rwtema.extrautils2.blocks.BlockResonator;
import com.rwtema.extrautils2.blocks.BlockScreen;
import com.rwtema.extrautils2.blocks.BlockSoundMuffler;
import com.rwtema.extrautils2.blocks.BlockSpotlight;
import com.rwtema.extrautils2.blocks.BlockTrashCan;
import com.rwtema.extrautils2.blocks.BlockWardChunkLoader;
import com.rwtema.extrautils2.crafting.AlwaysLast;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.entity.EntityBoomerang;
import com.rwtema.extrautils2.eventhandlers.CreativeEPHandler;
import com.rwtema.extrautils2.eventhandlers.ProddingStickHandler;
import com.rwtema.extrautils2.eventhandlers.RareSeedHandler;
import com.rwtema.extrautils2.items.ItemAngelBlock;
import com.rwtema.extrautils2.items.ItemAngelRing;
import com.rwtema.extrautils2.items.ItemBagOfHolding;
import com.rwtema.extrautils2.items.ItemBlockPlantable;
import com.rwtema.extrautils2.items.ItemBook;
import com.rwtema.extrautils2.items.ItemBoomerang;
import com.rwtema.extrautils2.items.ItemBuildersWand;
import com.rwtema.extrautils2.items.ItemContract;
import com.rwtema.extrautils2.items.ItemDestructionWand;
import com.rwtema.extrautils2.items.ItemFakeCopy;
import com.rwtema.extrautils2.items.ItemGlassCutter;
import com.rwtema.extrautils2.items.ItemGoldenLasso;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.items.ItemLawSword;
import com.rwtema.extrautils2.items.ItemPowerManager;
import com.rwtema.extrautils2.items.ItemSunCrystal;
import com.rwtema.extrautils2.items.ItemWateringCan;
import com.rwtema.extrautils2.items.ItemWrench;
import com.rwtema.extrautils2.tile.TileChunkLoader;
import com.rwtema.extrautils2.tile.TilePassiveGenerator;
import com.rwtema.extrautils2.tile.TilePlayerChest;
import com.rwtema.extrautils2.tile.TilePowerHandCrank;
import com.rwtema.extrautils2.tile.TilePowerOverload;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.tile.TileScreen;
import com.rwtema.extrautils2.tile.TileSoundMuffler;
import com.rwtema.extrautils2.tile.TileSpotlight;
import com.rwtema.extrautils2.tile.TileTrashCan;
import com.rwtema.extrautils2.transfernodes.BlockIndexer;
import com.rwtema.extrautils2.transfernodes.BlockTransferHolder;
import com.rwtema.extrautils2.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils2.transfernodes.ItemBlockPipe;
import com.rwtema.extrautils2.transfernodes.ItemGrocket;
import com.rwtema.extrautils2.transfernodes.ItemIndexerRemote;
import com.rwtema.extrautils2.transfernodes.TileIndexer;
import com.rwtema.extrautils2.transfernodes.TileTransferHolder;
import com.rwtema.extrautils2.utils.helpers.DungeonHelper;
import com.rwtema.extrautils2.worldgen.SingleChunkGen;
import com.rwtema.extrautils2.worldgen.SingleChunkWorldGenManager;
import java.lang.ref.WeakReference;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraftforge.common.config.Configuration;

public class XU2Entries {
    public static final IItemStackMaker magical_wood = BlockDecorativeSolidWood.DecorStates.magical_wood;
    public static final IItemStackMaker redstoneCrystal = ItemIngredients.Type.REDSTONE_CRYSTAL;
    public static final IItemStackMaker stoneburnt = BlockDecorativeSolid.DecorStates.stoneburnt;
    public static ItemEntry<ItemWateringCan> wateringCan = new ItemClassEntry<ItemWateringCan>(ItemWateringCan.class){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStackLowestDamage(), "S  ", "SBS", " S ", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('B'), Items.field_151054_z);
        }
    };
    public static ItemEntry<ItemDestructionWand> destructionWand = new ItemEntry<ItemDestructionWand>("ItemDestructionWand"){

        @Override
        public ItemDestructionWand initValue() {
            return new ItemDestructionWand(this.name.toLowerCase().substring(4), this.name, new float[]{0.95686275f, 0.9019608f, 0.30588236f}, 9);
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Destruction Wand", "Breaks blocks", this, buildersWand);
        }

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(), " GG", " WG", "W  ", Character.valueOf('W'), magical_wood, Character.valueOf('G'), "ingotGold");
        }
    };
    public static ItemEntry<ItemDestructionWand> creativeDestructionWand = new ItemEntry<ItemDestructionWand>("ItemCreativeDestructionWand"){

        @Override
        public ItemDestructionWand initValue() {
            return new ItemDestructionWand(this.name.toLowerCase().substring(4), this.name, new float[]{0.99215686f, 0.5921569f, 0.15294118f}, 49);
        }
    };
    public static ItemEntry<ItemBuildersWand> buildersWand = new ItemEntry<ItemBuildersWand>("ItemBuildersWand"){

        @Override
        public ItemBuildersWand initValue() {
            return new ItemBuildersWand(this.name, 9, this.name.toLowerCase().substring(4), new float[]{0.95686275f, 0.9019608f, 0.30588236f});
        }

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(), "  G", " W ", "W  ", Character.valueOf('W'), magical_wood, Character.valueOf('G'), "ingotGold");
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Builders Wand", "Places blocks on blocks", this, magical_wood);
        }
    };
    public static ItemEntry<ItemBuildersWand> creativeBuildersWand = new ItemEntry<ItemBuildersWand>("ItemCreativeBuildersWand"){

        @Override
        public ItemBuildersWand initValue() {
            return new ItemBuildersWand(this.name, 49, "creativebuilderswand", new float[]{0.99215686f, 0.5921569f, 0.15294118f});
        }
    };
    public static BlockClassEntry<BlockSoundMuffler> soundMuffler = new BlockClassEntry<BlockSoundMuffler>(BlockSoundMuffler.class, new Class[]{TileSoundMuffler.class}){

        @Override
        public void addRecipes() {
            this.addShapeless((Block)this.value, Blocks.field_150325_L, Blocks.field_150323_B);
        }
    };
    public static BlockEntry<BlockEnderLilly> blockEnderLilly = new BlockClassEntry<BlockEnderLilly>(BlockEnderLilly.class, new Class[0]){
        final IBlockState target = Blocks.field_150377_bs.func_176223_P();

        @Override
        public void postInit() {
            RareSeedHandler.register(this.newStack(1), 0.0078125);
            DungeonHelper.addDungeonItem(this.newStack(5), 1, 3, "dungeonChest", 0.03);
            SingleChunkWorldGenManager.register(new SingleChunkGen("EnderLillies", 0){

                @Override
                public void genChunk(Chunk chunk, IChunkProvider provider, Random random) {
                    int dz;
                    if (!(provider instanceof ChunkProviderEnd)) {
                        return;
                    }
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    int dx = random.nextInt(16);
                    int dy = chunk.func_76611_b(dx, dz = random.nextInt(16)) - 1;
                    if (dy <= 0) {
                        return;
                    }
                    pos.func_181079_c(dx, dy, dz);
                    IBlockState blockState = chunk.func_177435_g((BlockPos)pos);
                    if (blockState == target) {
                        pos.func_181079_c(dx, dy + 1, dz);
                        if (this.isAir(chunk, (BlockPos)pos)) {
                            this.setBlockState(chunk, (BlockPos)pos, ((BlockEnderLilly)((Object)value)).FULLY_GROWN_STATE);
                        }
                    }
                }
            });
        }
    }.setItemClass(ItemBlockPlantable.class);
    public static BlockEntry<BlockDecorativeSolidWood> decorativeSolidWood = new BlockClassEntry<BlockDecorativeSolidWood>(BlockDecorativeSolidWood.class, new Class[0]){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Magical Wood", "*snicker*", magical_wood, null);
        }

        @Override
        public void addRecipes() {
            for (BlockDecorativeSolidWood.DecorStates decorState : BlockDecorativeSolidWood.DecorStates.values()) {
                decorState.addRecipes();
            }
        }
    };
    public static BlockEntry<BlockTrashCan> trashCan = new BlockClassEntry<BlockTrashCan>(BlockTrashCan.class, new Class[]{TileTrashCan.class}){

        @Override
        public void addRecipes() {
            this.addShaped((Block)this.value, "SSS", "CcC", "CCC", Character.valueOf('S'), "stone", Character.valueOf('C'), "cobblestone", Character.valueOf('c'), Blocks.field_150486_ae);
        }
    };
    public static BlockEntry<BlockAngelBlock> angelBlock = new BlockEntry<BlockAngelBlock>("AngelBlock", new Class[0]){

        @Override
        public BlockAngelBlock initValue() {
            return new BlockAngelBlock();
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), " G ", "WOW", Character.valueOf('G'), "ingotGold", Character.valueOf('W'), Items.field_151008_G, Character.valueOf('O'), Blocks.field_150343_Z);
        }
    }.setItemClass(ItemAngelBlock.class);
    public static BlockEntry<BlockPassiveGenerator> passiveGenerator = new BlockClassEntry<BlockPassiveGenerator>(BlockPassiveGenerator.class, new Class[]{TilePassiveGenerator.class, TilePowerHandCrank.class}){

        @Override
        public void addRecipes() {
            for (BlockPassiveGenerator.GeneratorTypes generatorTypes : BlockPassiveGenerator.GeneratorTypes.values()) {
                generatorTypes.addRecipe();
            }
        }

        @Override
        public void addAchievements() {
            for (BlockPassiveGenerator.GeneratorTypes generatorTypes : BlockPassiveGenerator.GeneratorTypes.values()) {
                generatorTypes.registerAchievements();
            }
        }
    };
    public static BlockClassEntry<BlockCursedEarth> cursedEarth = new BlockClassEntry<BlockCursedEarth>(BlockCursedEarth.class, new Class[0]);
    public static BlockClassEntry<BlockRedstoneClock> redstoneClock = new BlockClassEntry<BlockRedstoneClock>(BlockRedstoneClock.class, new Class[0]){

        @Override
        public void addRecipes() {
            this.addShaped((Block)this.value, "SRS", "RTR", "SRS", Character.valueOf('S'), "stone", Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('R'), Items.field_151137_ax);
        }
    };
    public static ItemClassEntry<ItemGoldenLasso> goldenLasso = new ItemClassEntry<ItemGoldenLasso>(ItemGoldenLasso.class){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Golden Lasso", "Animal Transport", this.getOreDicMaker(), magical_wood);
            AchievementHelper.addAchievement("Cursed Lasso", "Evil Monster Capture", this.getMetaMaker(1), this.getOreDicMaker());
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1, 0), "gsg", "ses", "gsg", Character.valueOf('s'), Items.field_151007_F, Character.valueOf('g'), "nuggetGold", Character.valueOf('e'), Items.field_151079_bi);
            this.addShapeless(this.newStack(1, 1), this.newStack(1, 0), new ItemStack(Items.field_151144_bL, 1, 1));
        }
    };
    public static BlockCompressedEntry compressedCobblestone = new BlockCompressedEntry(Blocks.field_150347_e, "cobblestone", 8);
    public static BlockCompressedEntry compressedDirt = new BlockCompressedEntry(Blocks.field_150346_d, "dirt", 4);
    public static BlockCompressedEntry compressedSand = new BlockCompressedEntry((Block)Blocks.field_150354_m, "sand", 2);
    public static BlockCompressedEntry compressedGravel = new BlockCompressedEntry(Blocks.field_150351_n, "gravel", 2);
    public static BlockCompressedEntry compressedNetherack = new BlockCompressedEntry(Blocks.field_150424_aL, "netherrack", 6);
    public static BlockEntry<BlockSpotlight> blockSpotlight = new BlockClassEntry<BlockSpotlight>(BlockSpotlight.class, new Class[]{TileSpotlight.class}){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Spotlight", "Shine light across the world", this, sunCrystal);
        }

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(8), true, "BBB", "GRB", "BBB", Character.valueOf('G'), sunCrystal.newStack(1), Character.valueOf('R'), redstoneCrystal.newStack(), Character.valueOf('B'), stoneburnt);
        }
    };
    public static ItemClassEntry<ItemFakeCopy> itemFakeCopy = new ItemClassEntry<ItemFakeCopy>(ItemFakeCopy.class);
    public static ItemClassEntry<ItemGlassCutter> itemGlassCutter = new ItemClassEntry<ItemGlassCutter>(ItemGlassCutter.class){

        @Override
        public void addRecipes() {
            this.addShaped((Item)this.value, "  i", " si", "i  ", Character.valueOf('s'), "stickWood", Character.valueOf('i'), "ingotIron");
        }
    };
    public static ItemEnderShardEntry itemEnderShard = new ItemEnderShardEntry();
    public static BlockEntry<BlockRedOrchid> blockRedOrchid = new BlockClassEntry<BlockRedOrchid>(BlockRedOrchid.class, new Class[0]){

        @Override
        public void postInit() {
            SingleChunkWorldGenManager.register(new SingleChunkGen("RedOrchid", 0){

                @Override
                public void genChunk(Chunk chunk, IChunkProvider provider, Random random) {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    block0: for (int i = 0; i < 256; ++i) {
                        int dx = random.nextInt(16);
                        int dz = random.nextInt(16);
                        int dy = 1 + random.nextInt(32);
                        pos.func_181079_c(dx, dy, dz);
                        Block block = chunk.func_177435_g((BlockPos)pos).func_177230_c();
                        if (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay) continue;
                        for (int j = 1; j < 3; ++j) {
                            pos.func_181079_c(dx, dy + j, dz);
                            block = chunk.func_177435_g((BlockPos)pos).func_177230_c();
                            if (block == Blocks.field_150350_a) {
                                this.report(chunk, dx, dy, dz);
                                this.setBlockState(chunk, (BlockPos)pos, ((BlockRedOrchid)((Object)value)).FULLY_GROWN_STATE);
                                continue block0;
                            }
                            if (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay) continue block0;
                        }
                    }
                }
            });
            RareSeedHandler.register(this.newStack(1), 0.015625);
            DungeonHelper.addDungeonItem(this.newStack(5), 2, 5, "dungeonChest", 0.05);
        }
    }.setItemClass(ItemBlockPlantable.class);
    public static VoidEntry additionalVanillaRecipes = new VoidEntry("additionalVanillaRecipes"){

        @Override
        public void addRecipes() {
            CraftingHelper.addRecipe((IRecipe)new AlwaysLast.XUShapedRecipeAlwaysLast(new ItemStack((Block)Blocks.field_150486_ae, 4), "WWW", "W W", "WWW", Character.valueOf('W'), "logWood"));
            CraftingHelper.addRecipe((IRecipe)new AlwaysLast.XUShapedRecipeAlwaysLast(new ItemStack(Items.field_151055_y, 16), "W", "W", Character.valueOf('W'), "logWood"));
        }
    };
    public static ItemClassEntry<ItemLawSword> lawSword = new ItemClassEntry<ItemLawSword>(ItemLawSword.class){};
    public static ItemEntrySickle[] sickles = new ItemEntrySickle[]{new ItemEntrySickle(0), new ItemEntrySickle(1), new ItemEntrySickle(2), new ItemEntrySickle(3), new ItemEntrySickle(4)};
    public static ItemEntry<ItemAngelRing> angelRing = new ItemClassEntry<ItemAngelRing>(ItemAngelRing.class){

        @Override
        public void addRecipes() {
            Object[] leftWing = new Object[]{"blockGlass", Items.field_151008_G, "dyePurple", Items.field_151116_aA, "nuggetGold", new ItemStack(Items.field_151044_h, 1, 0)};
            Object[] rightWing = new Object[]{"blockGlass", Items.field_151008_G, "dyePink", Items.field_151116_aA, "nuggetGold", new ItemStack(Items.field_151044_h, 1, 1)};
            for (int i = 0; i < leftWing.length; ++i) {
                this.addShaped(this.newStack(1, i), !Objects.equal((Object)leftWing[i], (Object)rightWing[i]), "LGR", "GrG", "BGH", Character.valueOf('L'), leftWing[i], Character.valueOf('R'), rightWing[i], Character.valueOf('B'), ItemGoldenLasso.newCraftingStack(EntityBat.class), Character.valueOf('G'), "ingotGold", Character.valueOf('r'), redstoneCrystal, Character.valueOf('H'), ItemGoldenLasso.newCraftingStack(EntityGhast.class));
                this.addShapeless(this.newStack(1, i), leftWing[i], this.newWildcardStack(), rightWing[i]);
            }
        }
    };
    public static BlockClassEntry<BlockScreen> blockScreen = new BlockClassEntry<BlockScreen>(BlockScreen.class, new Class[]{TileScreen.class}){

        @Override
        public void loadAdditionalConfig(Configuration config) {
            BlockScreen.maxSize = 262144;
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Screen", "For you viewing pleasure", this, stoneburnt);
        }

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(1), true, "BBB", "ERE", Character.valueOf('G'), sunCrystal.newStack(), Character.valueOf('R'), redstoneCrystal, Character.valueOf('B'), stoneburnt, Character.valueOf('E'), itemEnderShard.newStack());
        }
    };
    public static BlockClassEntry<BlockPowerOverload> overload = new BlockClassEntry<BlockPowerOverload>(BlockPowerOverload.class, TilePowerOverload.class);
    public static BlockClassEntry<BlockResonator> resonator = new BlockClassEntry<BlockResonator>(BlockResonator.class, new Class[]{TileResonator.class}){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Power Resonator", "Imbue energy to objects", this, BlockPassiveGenerator.GeneratorTypes.Solar);
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), "RCR", "IcI", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), "blockCoal", Character.valueOf('c'), redstoneCrystal);
        }
    };
    public static ItemEntry<ItemSunCrystal> sunCrystal = new ItemClassEntry<ItemSunCrystal>(ItemSunCrystal.class){
        IItemStackMaker EMPTY_GEM = new IItemStackMaker(){

            @Override
            public ItemStack newStack() {
                return this.newStackLowestDamage();
            }
        };

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Luminescent Potential", "Collect the suns rays", this.EMPTY_GEM, resonator);
            AchievementHelper.addAchievement("Sun Crystal", "Light through walls", this, this.EMPTY_GEM);
        }

        @Override
        public void addRecipes() {
            this.addShapeless(this.newStackLowestDamage(), "gemDiamond", "dustGlowstone", "dustGlowstone", "dustGlowstone", "dustGlowstone");
        }
    };
    public static BlockEntry<BlockDecorativeSolid> decorativeSolid = new BlockClassEntry<BlockDecorativeSolid>(BlockDecorativeSolid.class, new Class[0]){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Powered Stone", "Stone that conducts intense amounts of energy", stoneburnt, resonator);
        }

        @Override
        public void addRecipes() {
            for (BlockDecorativeSolid.DecorStates decorState : BlockDecorativeSolid.DecorStates.values()) {
                decorState.addRecipes();
            }
        }

        @Override
        public void postInit() {
            if (XU2Entries.blockEnderLilly.enabled) {
                BlockEnderLilly.end_stone_states.add(((BlockDecorativeSolid)((Object)this.value)).func_176223_P().func_177226_a(BlockDecorativeSolid.decor, (Comparable)((Object)BlockDecorativeSolid.DecorStates.endstone)));
            }
        }
    };
    public static ItemClassEntry<ItemIngredients> itemIngredients = new ItemClassEntry<ItemIngredients>(ItemIngredients.class){

        @Override
        public void addAchievements() {
            for (ItemIngredients.Type type : ItemIngredients.Type.values()) {
                type.addAchievement();
            }
        }

        @Override
        public void addRecipes() {
            for (ItemIngredients.Type type : ItemIngredients.Type.values()) {
                type.addRecipes();
            }
        }
    };
    public static ItemClassEntry<ItemPowerManager> powerManager = new ItemClassEntry<ItemPowerManager>(ItemPowerManager.class){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), " c", "ss", "ss", Character.valueOf('s'), "stone", Character.valueOf('c'), redstoneCrystal);
        }
    };
    public static ItemClassEntry<ItemBagOfHolding> bagOfHolding = new ItemClassEntry<ItemBagOfHolding>(ItemBagOfHolding.class){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(), "ggg", "cBc", "ggg", Character.valueOf('g'), "ingotGold", Character.valueOf('c'), Blocks.field_150486_ae, Character.valueOf('B'), magical_wood);
        }
    };
    public static BlockClassEntry<BlockDecorativeGlass> decorativeGlass = new BlockClassEntry<BlockDecorativeGlass>(BlockDecorativeGlass.class, new Class[0]){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Powered Glass", "Glass that gives off energy", BlockDecorativeGlass.DecorStates.glass_redstone, resonator);
        }

        @Override
        public void addRecipes() {
            for (BlockDecorativeGlass.DecorStates decorState : BlockDecorativeGlass.DecorStates.values()) {
                decorState.addRecipes();
            }
        }
    };
    public static VoidEntry proddingStick = new VoidEntry("WoodenStickPoke"){

        @Override
        public void postInit() {
            ProddingStickHandler.register();
        }
    };
    public static BlockClassEntry<BlockMoonStone> moonStone = (BlockClassEntry)new BlockClassEntry<BlockMoonStone>(BlockMoonStone.class, new Class[0]){

        @Override
        public void postInit() {
            SingleChunkWorldGenManager.register(new SingleChunkGen("MoonStone", 0){
                public IBlockState defaultState;
                {
                    this.defaultState = ((BlockMoonStone)((Object)value)).func_176223_P();
                }

                @Override
                public void genChunk(Chunk chunk, IChunkProvider provider, Random random) {
                    for (int i = 0; i < 4; ++i) {
                        int dz;
                        int dy;
                        int dx = 1 + random.nextInt(14);
                        BlockPos pos = new BlockPos(dx, dy = 1 + random.nextInt(64), dz = 1 + random.nextInt(14));
                        if (chunk.func_177435_g(pos) != BlockMoonStone.mimicState) continue;
                        for (EnumFacing facing : EnumFacing.values()) {
                            if (!this.isAir(chunk, pos, facing)) continue;
                            this.setBlockState(chunk, pos, this.defaultState);
                            return;
                        }
                    }
                }
            });
        }
    }.setItemClass(null);
    public static MultiBlockEntry<BlockTransferPipe> pipe = new MultiBlockEntry<BlockTransferPipe>(BlockTransferPipe.stateBuilder, "pipe"){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Pipes!", "Point to Point Transport", this, resonator);
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(64), "SSS", "GRG", "SSS", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('G'), "blockGlass", Character.valueOf('R'), "dustRedstone");
        }
    }.setItemBlockClass(ItemBlockPipe.class);
    public static BlockEntry<BlockTransferHolder> holder = new BlockClassEntry<BlockTransferHolder>(BlockTransferHolder.class, new Class[]{TileTransferHolder.class}){

        @Override
        public String getConfigLabel() {
            return pipe.getConfigLabel();
        }
    }.setItemClass(null);
    public static ItemClassEntry<ItemGrocket> grocket = new ItemClassEntry<ItemGrocket>(ItemGrocket.class){

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(1, 0), "RPR", "SCS", Character.valueOf('P'), pipe, Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), "stone", Character.valueOf('C'), redstoneCrystal);
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Transfer Nodes", "Simple Item Management", (IItemStackMaker)this.metaCache.getUnchecked((Object)0), pipe);
        }

        @Override
        public String getConfigLabel() {
            return pipe.getConfigLabel();
        }
    };
    public static BlockClassEntry<BlockPlayerChest> playerChest = new BlockClassEntry<BlockPlayerChest>(BlockPlayerChest.class, new Class[]{TilePlayerChest.class}){

        @Override
        public void addRecipes() {
            this.addShaped((Block)this.value, "SSS", "SCS", "ScS", Character.valueOf('S'), stoneburnt, Character.valueOf('C'), Blocks.field_150477_bB, Character.valueOf('c'), redstoneCrystal);
        }
    };
    public static ItemClassEntry<ItemWrench> wrench = new ItemClassEntry<ItemWrench>(ItemWrench.class){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Wrench", "Wrench it!", this, null);
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), " RS", " Sr", "S  ", Character.valueOf('S'), "ingotIron", Character.valueOf('R'), "dyeRed", Character.valueOf('r'), "dustRedstone");
        }
    };
    public static ItemClassEntry<ItemBoomerang> boomerang = new ItemClassEntry<ItemBoomerang>(ItemBoomerang.class){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Boomerang", "It returns", this, magical_wood);
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), " W ", "W W", Character.valueOf('W'), magical_wood);
        }

        @Override
        public void postInit() {
            BlockDispenser.field_149943_a.func_82595_a(this.value, (Object)new BehaviorDefaultDispenseItem(){

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    EntityBoomerang t;
                    World world = source.func_82618_k();
                    TileEntity tile = source.func_150835_j();
                    if (tile == null) {
                        return stack;
                    }
                    WeakReference<EntityBoomerang> reference = EntityBoomerang.getBoomerangOwners(world).get(tile);
                    if (reference != null && (t = (EntityBoomerang)((Object)reference.get())) != null && !t.field_70128_L) {
                        return stack;
                    }
                    IPosition position = BlockDispenser.func_149939_a((IBlockSource)source);
                    EnumFacing direction = BlockDispenser.func_149937_b((int)source.func_82620_h());
                    EntityBoomerang boomerang = new EntityBoomerang(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), tile);
                    boomerang.func_70186_c(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e(), 0.75f, 4.0f);
                    world.func_72838_d((Entity)boomerang);
                    return stack;
                }

                protected void func_82485_a(IBlockSource source) {
                    source.func_82618_k().func_175718_b(1002, source.func_180699_d(), 0);
                }
            });
        }
    };
    public static ItemClassEntry<ItemBook> book = new ItemClassEntry<ItemBook>(ItemBook.class){

        @Override
        public void addRecipes() {
            CraftingHelper.addShapeless(this.newStack(1), ImmutableList.of((Object)Items.field_151122_aG, (Object)Items.field_151099_bA, (Object)Items.field_151164_bB), "ingotGold", Blocks.field_150343_Z);
        }
    };
    public static BlockClassEntry<BlockIndexer> indexer = new BlockClassEntry<BlockIndexer>(BlockIndexer.class, new Class[]{TileIndexer.class}){

        @Override
        public void addRecipes() {
            this.addShaped((Block)this.value, "SCS", "SsS", "SCS", Character.valueOf('S'), stoneburnt, Character.valueOf('C'), ItemIngredients.Type.EYE_REDSTONE, Character.valueOf('s'), blockScreen);
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Indexer", "Item Retrieval", this, grocket.getMetaMaker(0));
        }
    };
    public static ItemClassEntry<ItemIndexerRemote> indexerRemote = new ItemClassEntry<ItemIndexerRemote>(ItemIndexerRemote.class){

        @Override
        public void addRecipes() {
            this.addShaped((Item)this.value, "SCS", "SsS", "SCS", Character.valueOf('S'), "stone", Character.valueOf('C'), redstoneCrystal, Character.valueOf('s'), blockScreen.newStack());
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Remote Indexing", "Item Retrieval at distance", this, indexer);
        }
    };
    public static VoidEntry throwEnderPearlsInCreative = new VoidEntry("throwEnderPearlsInCreative"){

        @Override
        public void postInit() {
            CreativeEPHandler.init();
        }
    };
    public static ItemClassEntry<ItemContract> contract = new ItemClassEntry<ItemContract>(ItemContract.class){

        @Override
        public void addRecipes() {
            CraftingHelper.addShapeless(this.newStack(1), Items.field_151008_G, Items.field_151121_aF, Items.field_151069_bo, "dyeBlack");
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Villager Contract", "Head of Villager Soul Resources", this, goldenLasso.getOreDicMaker());
        }
    };
    public static BlockClassEntry<BlockWardChunkLoader> ward_chunkloader = new BlockClassEntry<BlockWardChunkLoader>("ChunkLoader", BlockWardChunkLoader.class, new Class[]{TileChunkLoader.class}){

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(1), "SES", "SLS", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('E'), ItemIngredients.Type.EYE_REDSTONE.newStack(1), Character.valueOf('L'), ItemGoldenLasso.newCraftingVillagerStack(true, null));
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Chunk Loader", "Persistence", this, contract);
        }
    };

    public static void init() {
    }
}

