/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class EntryHandler {
    public static List<Entry> entries = Lists.newArrayList();
    public static List<Entry> activeEntries = Lists.newArrayList();
    public static HashMap<String, Entry> entryHashMap = new HashMap();

    public static void loadConfig(Configuration config) {
        HashMap configEntries = Maps.newHashMap();
        for (Entry entry : entries) {
            entryHashMap.put(entry.name.toLowerCase(), entry);
            configEntries.put(entry.name, config.get("Enabled", entry.getConfigLabel(), true).getBoolean());
            entry.loadAdditionalConfig(config);
        }
        for (Entry entry : entries) {
            entry.enabled = (Boolean)configEntries.get(entry.name);
            if (entry.dependencies != null && entry.enabled) {
                for (String dependency : entry.dependencies) {
                    if (((Boolean)configEntries.get(dependency)).booleanValue()) continue;
                    entry.enabled = false;
                    break;
                }
            }
            if (!entry.enabled) continue;
            activeEntries.add(entry);
        }
    }

    public static void preInit() {
        for (Entry entry : activeEntries) {
            entry.preInitLoad();
        }
        for (Entry entry : activeEntries) {
            entry.preInitRegister();
        }
        for (Entry entry : entries) {
            entry.addAchievements();
        }
        for (Entry entry : activeEntries) {
            entry.registerOres();
        }
        for (Entry entry : activeEntries) {
            CraftingHelper.recipeCallback.set(entry.recipes);
            entry.addRecipes();
            CraftingHelper.recipeCallback.set(null);
        }
        AchievementHelper.bake();
    }

    public static void init() {
    }

    public static void postInit() {
        for (Entry entry : activeEntries) {
            entry.postInit();
        }
    }
}

