/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import java.util.EnumSet;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class XUBlockStatic
extends XUBlock {
    public HashMap<IBlockState, BoxModel> cachedModels = new HashMap<IBlockState, BoxModel>(){

        @Override
        public BoxModel get(Object key) {
            BoxModel boxes = (BoxModel)super.get(key);
            if (boxes == null || XUBlockStatic.recalc_models()) {
                IBlockState state = key != null ? (IBlockState)key : XUBlockStatic.this.func_176223_P();
                boxes = XUBlockStatic.this.getModel(state);
                super.put(state, boxes);
            }
            return boxes;
        }
    };
    public HashMap<IBlockState, BoxModel> cachedInvModels = new HashMap<IBlockState, BoxModel>(){

        @Override
        public BoxModel get(Object key) {
            BoxModel boxes = (BoxModel)super.get(key);
            if (boxes == null || XUBlockStatic.recalc_models()) {
                IBlockState state = key != null ? (IBlockState)key : XUBlockStatic.this.func_176223_P();
                boxes = XUBlockStatic.this.getModelInv(state);
                boxes.moveToCenterForInventoryRendering();
                super.put(state, boxes);
            }
            return boxes;
        }
    };
    public EnumSet<EnumWorldBlockLayer> set;

    public XUBlockStatic(Material materialIn) {
        super(materialIn);
    }

    public static boolean recalc_models() {
        return false;
    }

    @Override
    public void registerTextures() {
        for (IBlockState iBlockState : this.xuBlockState.func_177619_a()) {
            this.cachedModels.get(iBlockState).registerTextures();
        }
    }

    @Override
    public void clearCaches() {
        this.cachedModels.clear();
        this.cachedInvModels.clear();
        this.set = null;
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return this.cachedModels.get(state == null ? world.func_180495_p(pos) : state);
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return this.cachedInvModels.get(this.xuBlockState.getStateFromItemStack(item));
    }

    public BoxModel getModelInv(IBlockState state) {
        return this.getModel(state);
    }

    public abstract BoxModel getModel(IBlockState var1);

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        EnumSet<EnumWorldBlockLayer> set = this.set;
        if (set == null) {
            set = EnumSet.noneOf(EnumWorldBlockLayer.class);
            for (IBlockState iBlockState : this.xuBlockState.func_177619_a()) {
                for (Box box : this.cachedModels.get(iBlockState)) {
                    set.add(box.layer);
                }
            }
            this.set = set;
        }
        return set.contains(layer);
    }

    @Override
    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.cachedModels.get(state).getAABB(pos, true);
    }
}

