/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MapPopulator;
import net.minecraftforge.common.property.IUnlistedProperty;

public class XUBlockStateCreator
extends BlockState {
    public static final PropertyDirection ROTATION_HORIZONTAL = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection ROTATION_ALL = PropertyDirection.func_177713_a((String)"facing", Arrays.asList(EnumFacing.values()));
    public static final PropertyDirection ROTATION_HORIZONTAL_INC_DOWN = PropertyDirection.func_177713_a((String)"facing", Arrays.asList(EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH));
    public static final Map<EnumFacing, PropertyBool> FACING_BOOLEANS = new EnumMap<EnumFacing, PropertyBool>(MapPopulator.func_179400_b((Iterable)Lists.newArrayList((Object[])EnumFacing.values()), (Iterable)Lists.transform((List)Lists.newArrayList((Object[])EnumFacing.values()), (Function)new Function<EnumFacing, PropertyBool>(){

        @Nullable
        public PropertyBool apply(EnumFacing input) {
            return PropertyBool.func_177716_a((String)input.func_176610_l().toLowerCase());
        }
    })));
    public static final Comparator<IProperty> property_sorter = new Comparator<IProperty>(){

        @Override
        public int compare(IProperty p_compare_1_, IProperty p_compare_2_) {
            return p_compare_1_.func_177701_a().compareTo(p_compare_2_.func_177701_a());
        }
    };
    public final String[] dropNames;
    public final HashMap<IProperty, Comparable> defaultValues;
    public final IBlockState defaultState;
    protected final TObjectIntHashMap<IBlockState> state2meta = new TObjectIntHashMap();
    protected final TObjectIntHashMap<IBlockState> state2dropMeta = new TObjectIntHashMap();
    final IBlockState[] meta2state;
    protected final IBlockState[] dropmeta2state;
    public XUBlock mainBlock;

    protected XUBlockStateCreator(XUBlock block, IProperty<? extends Comparable>[] worldProperties, IProperty<? extends Comparable>[] dropProperties, HashMap<IProperty, Comparable> defaultValues) {
        super((Block)block, XUBlockStateCreator.joinProperties(worldProperties, dropProperties), null);
        IBlockState metaState;
        this.mainBlock = block;
        Arrays.sort(worldProperties, property_sorter);
        Arrays.sort(dropProperties, property_sorter);
        this.defaultValues = defaultValues == null ? new HashMap() : defaultValues;
        for (IProperty iProperty : this.func_177623_d()) {
            if (defaultValues != null && this.defaultValues.containsKey(iProperty)) continue;
            Collection allowedValues = iProperty.func_177700_c();
            this.defaultValues.put(iProperty, (Comparable)Collections.min(allowedValues));
        }
        ImmutableList validStates = super.func_177619_a();
        IBlockState defaultState = (IBlockState)validStates.get(0);
        for (Map.Entry<IProperty, Comparable> entry : this.defaultValues.entrySet()) {
            defaultState = defaultState.func_177226_a(entry.getKey(), entry.getValue());
        }
        this.defaultState = defaultState;
        this.meta2state = this.createBlockStateArray((ImmutableList<IBlockState>)validStates);
        for (int i = 0; i < this.meta2state.length; ++i) {
            this.state2meta.put((Object)this.meta2state[i], i);
        }
        LinkedHashSet<IBlockState> dropMetas = new LinkedHashSet<IBlockState>();
        Iterator i$ = validStates.iterator();
        while (i$.hasNext()) {
            IBlockState validState;
            metaState = validState = (IBlockState)i$.next();
            for (IProperty<? extends Comparable> property : worldProperties) {
                metaState = metaState.func_177226_a(property, this.defaultValues.get(property));
            }
            dropMetas.add(metaState);
        }
        this.dropmeta2state = dropMetas.toArray(new IBlockState[dropMetas.size()]);
        for (int i = 0; i < this.dropmeta2state.length; ++i) {
            this.state2dropMeta.put((Object)this.dropmeta2state[i], i);
        }
        for (IBlockState validState : validStates) {
            if (this.state2dropMeta.containsKey((Object)validState)) continue;
            metaState = validState;
            for (IProperty<? extends Comparable> property : worldProperties) {
                metaState = metaState.func_177226_a(property, this.defaultValues.get(property));
            }
            this.state2dropMeta.put((Object)validState, this.state2dropMeta.get((Object)metaState));
        }
        this.dropNames = new String[this.dropmeta2state.length];
        for (int i = 0; i < this.dropNames.length; ++i) {
            IBlockState iBlockState = this.dropmeta2state[i];
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < dropProperties.length; ++j) {
                if (j != 0) {
                    builder.append(".");
                }
                builder.append(iBlockState.func_177229_b(dropProperties[j]).toString().toLowerCase());
            }
            this.dropNames[i] = builder.toString();
        }
        for (IBlockState validState : validStates) {
            XUBlockState xuBlockState = (XUBlockState)validState;
            xuBlockState.metadata = this.state2meta.get((Object)xuBlockState);
            xuBlockState.dropMeta = this.state2dropMeta.get((Object)xuBlockState);
            xuBlockState.dropName = this.dropNames[xuBlockState.dropMeta];
        }
    }

    public XUBlockStateCreator(XUBlock xuBlock) {
        this(xuBlock, new IProperty[0]);
    }

    public XUBlockStateCreator(XUBlock xuBlock, IProperty<?> ... properties) {
        this(xuBlock, properties, (IProperty<?>[])new IProperty[0]);
    }

    public XUBlockStateCreator(XUBlock xuBlock, boolean dummy, IProperty<?> ... dropProperties) {
        this(xuBlock, (IProperty<?>[])new IProperty[0], dropProperties);
    }

    public XUBlockStateCreator(XUBlock xuBlock, IProperty<?>[] properties, IProperty<?>[] dropProperties) {
        this(xuBlock, (IProperty<? extends Comparable>[])properties, (IProperty<? extends Comparable>[])dropProperties, (HashMap<IProperty, Comparable>)null);
    }

    public static IProperty<?>[] joinProperties(IProperty[] a, IProperty[] b) {
        if (b == null || b.length == 0) {
            return a;
        }
        IProperty[] properties = new IProperty[a.length + b.length];
        System.arraycopy(a, 0, properties, 0, a.length);
        System.arraycopy(b, 0, properties, a.length, b.length);
        return properties;
    }

    protected IBlockState[] createBlockStateArray(ImmutableList<IBlockState> validStates) {
        return (IBlockState[])validStates.toArray((Object[])new IBlockState[validStates.size()]);
    }

    protected BlockState.StateImplementation createState(Block block, ImmutableMap<IProperty, Comparable> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        return new XUBlockState(block, properties);
    }

    public IBlockState getStateFromMeta(XUBlock xuBlock, int meta) {
        if (meta < 0 || meta >= this.meta2state.length) {
            return this.defaultState;
        }
        return this.meta2state[meta];
    }

    public int getMetaFromState(IBlockState state) {
        int i = this.state2meta.get((Object)state);
        return i >= 0 ? i : 0;
    }

    public IBlockState getStateFromDropMeta(int meta) {
        if (meta < 0 || meta >= this.dropmeta2state.length) {
            return this.defaultState;
        }
        return this.dropmeta2state[meta];
    }

    public int getDropMetaFromState(IBlockState state) {
        int i = this.state2dropMeta.get((Object)state);
        return i >= 0 ? i : 0;
    }

    public IBlockState getStateFromItemStack(ItemStack item) {
        if (item == null) {
            return this.defaultState;
        }
        return this.getStateFromDropMeta(item.func_77952_i());
    }

    public static class Builder {
        final List<IProperty<? extends Comparable>> worldProperties = Lists.newArrayList();
        final List<IProperty<? extends Comparable>> dropProperties = Lists.newArrayList();
        final HashMap<IProperty, Comparable> defaultValues = Maps.newHashMap();
        final XUBlock block;

        public Builder(XUBlock block) {
            this.block = block;
        }

        public <T extends Comparable<T>> Builder addWorldPropertyWithDefault(IProperty<T> property, T value) {
            this.worldProperties.add(property);
            this.defaultValues.put(property, value);
            return this;
        }

        public <T extends Comparable<T>> Builder addDropPropertyWithDefault(IProperty<T> property, T value) {
            this.dropProperties.add(property);
            this.defaultValues.put(property, value);
            return this;
        }

        public Builder addWorldProperties(IProperty<?> ... properties) {
            Collections.addAll(this.worldProperties, properties);
            return this;
        }

        public Builder addDropProperties(IProperty<?> ... properties) {
            Collections.addAll(this.dropProperties, properties);
            return this;
        }

        public <T extends Comparable<T>> Builder setDefaultValue(IProperty<T> property, T value) {
            this.defaultValues.put(property, value);
            return this;
        }

        public Builder addWorldProperties(Collection<IProperty<?>> properties) {
            this.worldProperties.addAll(properties);
            return this;
        }

        public Builder addDropProperties(Collection<IProperty<?>> properties) {
            this.dropProperties.addAll(properties);
            return this;
        }

        public XUBlockStateCreator build() {
            IProperty[] worldProperties = this.worldProperties.toArray(new IProperty[this.worldProperties.size()]);
            IProperty[] dropProperties = this.dropProperties.toArray(new IProperty[this.dropProperties.size()]);
            return new XUBlockStateCreator(this.block, worldProperties, dropProperties, this.defaultValues.isEmpty() ? null : this.defaultValues);
        }
    }
}

