/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.tile.XUTile;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class XUBlock
extends Block {
    public static final List<XUBlock> blocks = Lists.newArrayList();
    public final ThreadLocal<Box> boundsOverride = new ThreadLocal();
    public XUBlockStateCreator xuBlockState;
    public XUItemBlock itemBlock;
    private boolean hasTile;

    public XUBlock(Material materialIn) {
        super(materialIn);
        this.func_149647_a(ExtraUtils2.creativeTabExtraUtils);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149769_e);
        this.setBlockState((XUBlockStateCreator)this.field_176227_L);
        ExtraUtils2.proxy.registerBlock(this);
        blocks.add(this);
    }

    protected static boolean isSolidForPlacing(World world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN && World.func_175683_a((IBlockAccess)world, (BlockPos)pos.func_177977_b()) || world.isSideSolid(pos.func_177972_a(side), side);
    }

    public static <T extends Comparable<T>> T getPropertySafe(World world, BlockPos pos, IProperty<T> property, T _default) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177228_b().containsKey(property)) {
            return (T)blockState.func_177229_b(property);
        }
        return _default;
    }

    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return this.getWorldModel(worldIn, pos, null).isFullCube();
    }

    public boolean func_149662_c() {
        return false;
    }

    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator(this);
    }

    public void setBlockName(String s) {
        this.func_149663_c(s);
    }

    @Nonnull
    public abstract BoxModel getWorldModel(IBlockAccess var1, BlockPos var2, @Nullable IBlockState var3);

    @SideOnly(value=Side.CLIENT)
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return this.getWorldModel(world, pos, state);
    }

    public boolean isNormalCube(IBlockAccess world, BlockPos pos) {
        return this.getWorldModel(world, pos, null).isFullCube();
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (this.xuBlockState.mainBlock == this) {
            for (int i = 0; i < this.xuBlockState.dropmeta2state.length; ++i) {
                list.add(new ItemStack(itemIn, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        return super.getPickBlock(target, world, pos, player);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public abstract BoxModel getInventoryModel(@Nullable ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        BoxModel worldModel = this.getRenderModel(world, pos, state);
        ((XUBlockState)state).load(worldModel);
        return state;
    }

    public BlockState func_176194_O() {
        return this.xuBlockState;
    }

    public void setBlockState(XUBlockStateCreator creator) {
        this.xuBlockState = creator;
        boolean hasTile = false;
        for (IBlockState iBlockState : this.xuBlockState.func_177619_a()) {
            if (!this.hasTileEntity(iBlockState)) continue;
            hasTile = true;
            break;
        }
        this.hasTile = hasTile;
        if (this.itemBlock != null) {
            this.itemBlock.func_77627_a(this.xuBlockState.dropmeta2state.length > 1);
        }
        this.func_180632_j(creator.defaultState);
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        BoxModel models = this.getWorldModel((IBlockAccess)worldIn, pos, state);
        if (models.isEmpty()) {
            return;
        }
        for (Box b : models) {
            AxisAlignedBB aabb;
            if (b.noCollide || !mask.func_72326_a(aabb = new AxisAlignedBB((double)((float)pos.func_177958_n() + b.minX), (double)((float)pos.func_177956_o() + b.minY), (double)((float)pos.func_177952_p() + b.minZ), (double)((float)pos.func_177958_n() + b.maxX), (double)((float)pos.func_177956_o() + b.maxY), (double)((float)pos.func_177952_p() + b.maxZ)))) continue;
            list.add(aabb);
        }
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        Box bounds = this.boundsOverride.get();
        if (bounds == null) {
            bounds = BoxModel.boundingBox(this.getWorldModel(worldIn, pos, null), false);
        }
        if (bounds != null) {
            this.func_149676_a(bounds.minX, bounds.minY, bounds.minZ, bounds.maxX, bounds.maxY, bounds.maxZ);
        }
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 start, Vec3 end) {
        BoxModel worldModel = this.getWorldModel((IBlockAccess)worldIn, pos, null);
        if (worldModel.overrideBounds != null) {
            return super.func_180636_a(worldIn, pos, start, end);
        }
        MovingObjectPosition result = null;
        try {
            for (Box box : worldModel) {
                this.boundsOverride.set(box);
                MovingObjectPosition r = super.func_180636_a(worldIn, pos, start, end);
                if (r == null || result != null && !(start.func_72438_d(r.field_72307_f) < start.func_72438_d(result.field_72307_f))) continue;
                result = r;
                result.subHit = box.tint;
            }
            this.boundsOverride.set(null);
        }
        catch (Throwable err) {
            this.boundsOverride.set(null);
            throw Throwables.propagate((Throwable)err);
        }
        return result;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.xuBlockState.getStateFromDropMeta(meta);
    }

    public int func_180651_a(IBlockState state) {
        return this.xuBlockState.getDropMetaFromState(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.xuBlockState.getStateFromMeta(this, meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.xuBlockState.getMetaFromState(state);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        int i = 0;
        Item item = Item.func_150898_a((Block)this.xuBlockState.mainBlock);
        if (item != null && item.func_77614_k()) {
            i = this.xuBlockState.getDropMetaFromState(state);
        }
        return new ItemStack(item, 1, i);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.xuBlockState.mainBlock);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
    }

    public void postTextureRegister() {
    }

    public XUTile getTile(World world, BlockPos pos) {
        return this.hasTile ? (XUTile)world.func_175625_s(pos) : null;
    }

    public <T extends XUTile> T getTileCast(World world, BlockPos pos) {
        return (T)((Object)this.getTile(world, pos));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        XUTile checkTile;
        if (this.hasTile && (checkTile = this.getTile(worldIn, pos)) != null) {
            checkTile.onBlockPlacedBy(worldIn, pos, state, placer, stack, this);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        if (this.hasTile && te != null && ((XUTile)te).harvestBlock(worldIn, player, pos, state)) {
            return;
        }
        super.func_180657_a(worldIn, player, pos, state, te);
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        XUTile checkTile;
        if (this.hasTile && this.hasTileEntity(state) && (checkTile = this.getTile(worldIn, pos)) != null) {
            checkTile.onNeighborBlockChange(worldIn, pos, state, neighborBlock);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        XUTile checkTile;
        if (this.hasTile && (checkTile = this.getTile(worldIn, pos)) != null) {
            checkTile.breakBlock(worldIn, pos, state);
        }
    }

    public void clearCaches() {
    }

    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInventoryQuads(MutableModel result, ItemStack stack) {
        BoxModel inventoryModel = this.getInventoryModel(stack);
        inventoryModel.loadIntoMutable(result, null);
    }

    @SideOnly(value=Side.CLIENT)
    public MutableModel createInventoryMutableModel() {
        return new MutableModel(Transforms.blockTransforms);
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        return this.getWorldModel((IBlockAccess)worldIn, pos, null).getAABB(pos, false);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return super.func_180640_a(worldIn, pos, state);
    }

    public <T extends Comparable<T>> T getMyPropertySafe(World world, BlockPos pos, IProperty<T> property) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            return (T)state.func_177229_b(property);
        }
        return (T)this.func_176223_P().func_177229_b(property);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        XUTile checkTile;
        if (this.hasTile && this.hasTileEntity(state) && (checkTile = this.getTile(worldIn, pos)) != null) {
            return checkTile.onBlockActivated(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return super.func_176205_b(worldIn, pos) || this.getWorldModel(worldIn, pos, null).getPassable();
    }

    public void onCreated(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        AchievementHelper.checkForPotentialAwards(playerIn, stack);
    }
}

