/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.backend.multiblockstate.XUBlockStateMulti;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Cartesian;
import net.minecraft.util.MapPopulator;
import net.minecraftforge.common.property.IUnlistedProperty;

public class MultiBlockStateBuilder<T extends XUBlock> {
    public final Class<T> clazz;
    private final List<IProperty<? extends Comparable>> worldProperties = Lists.newArrayList();
    private final List<IProperty<? extends Comparable>> dropProperties = Lists.newArrayList();
    private final HashMap<IProperty, Comparable> defaultValues = Maps.newHashMap();
    private final Constructor<T> constructor;
    private final Object[] parameters;
    public IBlockState[] meta2states;
    public TObjectIntHashMap<IBlockState> states2meta;
    public HashSet<IBlockState> genericPipeStates = new HashSet();
    public HashMap<Map<IProperty, Comparable>, XUBlockState> propertyStateBlockStatesMap;
    public boolean initialized = false;
    public XUBlockStateMulti defaultState;
    public T mainBlock;

    public MultiBlockStateBuilder(Class<T> clazz, Object ... parameters) {
        this.clazz = clazz;
        this.parameters = parameters;
        Class[] parameClazzes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameClazzes[i] = parameters[i] == null ? Integer.TYPE : parameters[i].getClass();
        }
        try {
            this.constructor = clazz.getConstructor(parameClazzes);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public MultiBlockStateBuilder<T> addWorldProperties(Collection<IProperty<?>> properties) {
        this.worldProperties.addAll(properties);
        return this;
    }

    public MultiBlockStateBuilder<T> addDropProperties(Collection<IProperty<?>> properties) {
        this.dropProperties.addAll(properties);
        return this;
    }

    public MultiBlockStateBuilder<T> addWorldProperties(IProperty<?> ... properties) {
        Collections.addAll(this.worldProperties, properties);
        return this;
    }

    public MultiBlockStateBuilder<T> addDropProperties(IProperty<?> ... properties) {
        Collections.addAll(this.dropProperties, properties);
        return this;
    }

    public <K extends Comparable<K>> MultiBlockStateBuilder<T> setDefaultValue(IProperty<K> property, K value) {
        this.defaultValues.put(property, value);
        return this;
    }

    public List<T> createBlocks(T firstBlock) {
        int i;
        int i2;
        IProperty[] worldProperties = this.worldProperties.toArray(new IProperty[this.worldProperties.size()]);
        IProperty[] dropProperties = this.dropProperties.toArray(new IProperty[this.dropProperties.size()]);
        IProperty<?>[] properties = XUBlockStateCreator.joinProperties(worldProperties, dropProperties);
        Arrays.sort(properties, XUBlockStateCreator.property_sorter);
        ArrayList allowedValues = Lists.newArrayList();
        for (IProperty<?> property : properties) {
            allowedValues.add(property.func_177700_c());
        }
        ArrayList propertyStates = Lists.newArrayList((Iterable)Cartesian.func_179321_a((Iterable)allowedValues));
        if (propertyStates.size() < 16) {
            throw new RuntimeException("No of iblockstates = " + propertyStates.size() + " - Dont be silly");
        }
        int numBlocks = (int)Math.ceil((double)propertyStates.size() / 16.0);
        ArrayList blocks = Lists.newArrayListWithCapacity((int)numBlocks);
        if (firstBlock != null) {
            blocks.add(firstBlock);
        }
        while (blocks.size() < numBlocks) {
            try {
                Object[] par = new Object[this.parameters.length];
                for (i2 = 0; i2 < par.length; ++i2) {
                    par[i2] = this.parameters[i2] == null ? Integer.valueOf(blocks.size()) : this.parameters[i2];
                }
                blocks.add(this.constructor.newInstance(par));
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
        this.mainBlock = (XUBlock)((Object)blocks.get(0));
        final HashMap<Map, XUBlock> propertyStateBlockMap = new HashMap<Map, XUBlock>();
        this.propertyStateBlockStatesMap = new HashMap();
        for (i2 = 0; i2 < propertyStates.size(); ++i2) {
            List propertState = (List)propertyStates.get(i2);
            Map map1 = MapPopulator.func_179400_b(Arrays.asList(properties), (Iterable)propertState);
            XUBlock t = (XUBlock)((Object)blocks.get(i2 / 16));
            propertyStateBlockMap.put(map1, t);
        }
        this.meta2states = new IBlockState[propertyStates.size()];
        HashMap<XUBlock, 1> map = new HashMap<XUBlock, 1>();
        for (i = 0; i < blocks.size(); ++i) {
            final XUBlock curBlock = (XUBlock)((Object)blocks.get(i));
            final ArrayList myStates = Lists.newArrayList();
            XUBlockStateCreator creator = new XUBlockStateCreator(curBlock, worldProperties, dropProperties, this.defaultValues){
                private ImmutableList<IBlockState> validStates;
                {
                    super(x0, x1, x2, x3);
                    this.mainBlock = this.mainBlock;
                }

                @Override
                protected BlockState.StateImplementation createState(Block block, ImmutableMap<IProperty, Comparable> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
                    if (MultiBlockStateBuilder.this.propertyStateBlockStatesMap.containsKey(properties)) {
                        XUBlockState xuBlockState = MultiBlockStateBuilder.this.propertyStateBlockStatesMap.get(properties);
                        xuBlockState.clearPropertyTable();
                        if (xuBlockState.func_177230_c() == curBlock) {
                            myStates.add(xuBlockState);
                        }
                        return xuBlockState;
                    }
                    XUBlock blockIn = (XUBlock)((Object)propertyStateBlockMap.get(properties));
                    XUBlockStateMulti state = MultiBlockStateBuilder.this.createXUBlockStateMulti(blockIn, properties, MultiBlockStateBuilder.this.mainBlock);
                    if (blockIn == curBlock) {
                        myStates.add(state);
                    }
                    MultiBlockStateBuilder.this.propertyStateBlockStatesMap.put((Map<IProperty, Comparable>)properties, state);
                    return state;
                }

                public ImmutableList<IBlockState> func_177619_a() {
                    return ImmutableList.copyOf((Collection)myStates);
                }

                @Override
                protected IBlockState[] createBlockStateArray(ImmutableList<IBlockState> validStates) {
                    return myStates.toArray(new IBlockState[myStates.size()]);
                }
            };
            System.arraycopy(creator.meta2state, 0, this.meta2states, i * 16, creator.meta2state.length);
            this.genericPipeStates.addAll(myStates);
            map.put(curBlock, creator);
        }
        this.states2meta = new TObjectIntHashMap();
        for (i = 0; i < this.meta2states.length; ++i) {
            this.states2meta.put((Object)this.meta2states[i], i);
        }
        this.defaultState = (XUBlockStateMulti)((XUBlockStateCreator)((Object)map.get(this.mainBlock))).defaultState;
        this.initialized = true;
        for (Map.Entry entry : map.entrySet()) {
            ((XUBlock)((Object)entry.getKey())).setBlockState((XUBlockStateCreator)((Object)entry.getValue()));
        }
        return blocks;
    }

    @Nonnull
    protected XUBlockStateMulti createXUBlockStateMulti(T blockIn, ImmutableMap<IProperty, Comparable> properties, T mainBlock) {
        return new XUBlockStateMulti((Block)blockIn, properties, (XUBlock)((Object)mainBlock));
    }
}

