/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.asm;

import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import java.util.EnumMap;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.util.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class Lighting {
    public static final WeakHashMap<World, EnumMap<EnumSkyBlock, Set<ILight>>> plusLights = new WeakHashMap();
    public static final WeakHashMap<World, EnumMap<EnumSkyBlock, Set<ILight>>> negLights = new WeakHashMap();
    static final EnumMap<EnumSkyBlock, Set<ILight>> baseMap = new EnumMap(EnumSkyBlock.class);

    public static void register(ILight light, WeakHashMap<World, EnumMap<EnumSkyBlock, Set<ILight>>> lightType) {
        EnumMap<EnumSkyBlock, Set<ILight>> enumMap = lightType.get(light.getLightWorld());
        if (enumMap == null) {
            enumMap = new EnumMap<EnumSkyBlock, Set<ILight>>(baseMap);
            lightType.put(light.getLightWorld(), enumMap);
        }
        for (EnumSkyBlock type : light.getLightType()) {
            Set<ILight> lightMap = enumMap.get(type);
            if (lightMap == null) {
                lightMap = new WeakLinkedSet<ILight>();
                enumMap.put(type, lightMap);
            }
            lightMap.add(light);
        }
    }

    public static void unregister(ILight light, WeakHashMap<World, EnumMap<EnumSkyBlock, Set<ILight>>> lightType) {
        EnumMap<EnumSkyBlock, Set<ILight>> enumMap = lightType.get(light.getLightWorld());
        if (enumMap == null) {
            return;
        }
        for (EnumSkyBlock type : EnumSkyBlock.values()) {
            Set<ILight> lightMap = enumMap.get(type);
            if (lightMap == null) continue;
            lightMap.remove(light);
            if (!lightMap.isEmpty()) continue;
            enumMap.remove(type);
            if (!enumMap.isEmpty()) continue;
            lightType.remove(light.getLightWorld());
        }
    }

    public static Set<ILight> getLightList(World world, BlockPos pos, EnumSkyBlock type, WeakHashMap<World, EnumMap<EnumSkyBlock, Set<ILight>>> lightType) {
        EnumMap<EnumSkyBlock, Set<ILight>> enumMap = lightType.get(world);
        if (enumMap == null) {
            return null;
        }
        Set<ILight> worldMap = enumMap.get(type);
        if (worldMap == null) {
            return null;
        }
        if (worldMap.isEmpty()) {
            enumMap.remove(type);
            if (enumMap.isEmpty()) {
                lightType.remove(world);
            }
            return null;
        }
        return worldMap;
    }

    public static int getLightFor(World world, EnumSkyBlock type, BlockPos pos, int curLevel) {
        if (plusLights.isEmpty() && negLights.isEmpty()) {
            return curLevel;
        }
        Set<ILight> negLightList = Lighting.getLightList(world, pos, type, negLights);
        Set<ILight> plusLightList = Lighting.getLightList(world, pos, type, plusLights);
        if (negLightList == null) {
            if (plusLightList == null) {
                return curLevel;
            }
            float level = curLevel;
            for (ILight iLight : plusLightList) {
                if (!((level += iLight.getLightOffset(pos)) > 15.0f)) continue;
                return 15;
            }
            return Math.min((int)level, 15);
        }
        float level = curLevel;
        if (plusLightList != null) {
            for (ILight iLight : plusLightList) {
                if ((level += iLight.getLightOffset(pos)) > 15.0f) break;
            }
        }
        if (level > 15.0f) {
            level = 15.0f;
        }
        for (ILight iLight : negLightList) {
            if (!((level += iLight.getLightOffset(pos)) < 0.0f)) continue;
            return 0;
        }
        return Math.max(0, (int)level);
    }

    public static int getCombinedLight(World world, BlockPos pos, int curLevel) {
        float level;
        block16: {
            Set<ILight> lightListN2;
            block15: {
                if (plusLights.isEmpty() && negLights.isEmpty()) {
                    return curLevel;
                }
                Set<ILight> lightListP1 = Lighting.getLightList(world, pos, EnumSkyBlock.BLOCK, plusLights);
                Set<ILight> lightListP2 = Lighting.getLightList(world, pos, EnumSkyBlock.SKY, plusLights);
                Set<ILight> lightListN1 = Lighting.getLightList(world, pos, EnumSkyBlock.BLOCK, negLights);
                lightListN2 = Lighting.getLightList(world, pos, EnumSkyBlock.SKY, negLights);
                if (lightListN1 == null && lightListN2 == null) {
                    if (curLevel == 15) {
                        return 15;
                    }
                    float level2 = curLevel;
                    if (lightListP1 != null) {
                        for (ILight iLight : lightListP1) {
                            if (!((level2 += iLight.getLightOffset(pos)) >= 15.0f)) continue;
                            return 15;
                        }
                    }
                    if (lightListP2 != null) {
                        for (ILight iLight : lightListP2) {
                            if (!((level2 += iLight.getLightOffset(pos)) >= 15.0f)) continue;
                            return 15;
                        }
                    }
                    return (int)level2;
                }
                level = curLevel;
                if (lightListP1 != null) {
                    for (ILight iLight : lightListP1) {
                        if ((level += iLight.getLightOffset(pos)) >= 15.0f) break;
                    }
                }
                if (lightListP2 != null && level < 15.0f) {
                    for (ILight iLight : lightListP2) {
                        if ((level += iLight.getLightOffset(pos)) >= 15.0f) break;
                    }
                }
                if (level > 15.0f) {
                    level = 15.0f;
                }
                if (lightListN1 == null) break block15;
                for (ILight iLight : lightListN1) {
                    if (!((level += iLight.getLightOffset(pos)) <= 0.0f)) continue;
                    return 0;
                }
                if (lightListN2 == null) break block16;
                for (ILight iLight : lightListN2) {
                    if (!((level += iLight.getLightOffset(pos)) <= 0.0f)) continue;
                    return 0;
                }
                break block16;
            }
            for (ILight iLight : lightListN2) {
                if (!((level += iLight.getLightOffset(pos)) <= 0.0f)) continue;
                return 0;
            }
        }
        return (int)level;
    }
}

