/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.asm;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.asm.LightingTransformer;
import com.rwtema.extrautils2.asm.TessellatorTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassTransformerHandler
implements IClassTransformer {
    static final ArrayList<IClassTransformer> transformers = Lists.newArrayList((Object[])new IClassTransformer[]{new LightingTransformer(), new TessellatorTransformer()});
    static Logger logger = LogManager.getLogger((String)"ExtraUtils2CoreMod");

    public ClassTransformerHandler() {
        logger.info("Transformer Created");
    }

    public byte[] transform(String s, String s2, byte[] bytes) {
        StringBuilder builder = null;
        Iterator<IClassTransformer> i$ = transformers.iterator();
        while (i$.hasNext()) {
            byte[] b = bytes;
            IClassTransformer transformer = i$.next();
            if (b == (bytes = transformer.transform(s, s2, bytes))) continue;
            if (builder == null) {
                builder = new StringBuilder("XU Transformer: ").append(s).append("(").append(s2).append(")").append(" {").append(transformer.toString());
                continue;
            }
            builder.append(",  ").append(transformer.toString());
        }
        if (builder != null) {
            builder.append("}");
            logger.info(builder.toString());
        }
        return bytes;
    }

    static {
        logger.info("Transformer Class Initialized");
    }
}

