/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.achievements;

import com.google.common.collect.HashMultimap;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.toposort.TopologicalSort;

public class AchievementHelper {
    private static HashMultimap<ItemRef, XUAchievement> dropMap = HashMultimap.create();
    private static HashMultimap<XUAchievement, XUAchievement> achievementChildren = HashMultimap.create();
    private static AchievementPage page;
    private static List<Achievement> achievements;
    private static HashMap<IItemStackMaker, XUAchievement> map;
    private static boolean built;
    private static HashSet<String> names;

    public static XUAchievement addAchievement(String name, String description, @Nonnull IItemStackMaker entry, @Nullable IItemStackMaker parent) {
        if (!names.add(name)) {
            throw new RuntimeException("Duplicate Name " + name);
        }
        XUAchievement achievement = new XUAchievement(name, description, entry, parent);
        map.put(entry, achievement);
        return achievement;
    }

    public static void bake() {
        if (page == null) {
            page = new AchievementPage("ExtraUtils 2", new Achievement[0]);
            AchievementPage.registerAchievementPage((AchievementPage)page);
            achievements = page.getAchievements();
        } else {
            achievements.clear();
            achievementChildren.clear();
            dropMap.clear();
        }
        TopologicalSort.DirectedGraph graph = new TopologicalSort.DirectedGraph();
        for (XUAchievement xuAchievement : map.values()) {
            graph.addNode((Object)xuAchievement);
        }
        for (XUAchievement xuAchievement : map.values()) {
            if (xuAchievement.parent == null) {
                achievementChildren.put(null, (Object)xuAchievement);
                continue;
            }
            xuAchievement.achParent = map.get(xuAchievement.parent);
            achievementChildren.put((Object)xuAchievement.achParent, (Object)xuAchievement);
            if (xuAchievement.achParent != null) {
                graph.addEdge((Object)xuAchievement.achParent, (Object)xuAchievement);
                continue;
            }
            xuAchievement.achParent = null;
        }
        List sort = TopologicalSort.topologicalSort((TopologicalSort.DirectedGraph)graph);
        for (int i = 0; i < 100; ++i) {
            new Layout().buildTree();
            for (XUAchievement a : sort) {
                for (XUAchievement b : sort) {
                    if (a == b || a.x != b.x || a.y != b.y) continue;
                    LogHelper.info(a + " " + b, new Object[0]);
                    throw new RuntimeException("Overlay\n " + a + "\n " + b);
                }
            }
        }
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        int xc = 0;
        int yc = 0;
        for (XUAchievement xuAchievement : sort) {
            minx = Math.min(minx, xuAchievement.x);
            miny = Math.min(miny, xuAchievement.y);
            maxx = Math.max(maxx, xuAchievement.x);
            maxy = Math.max(maxy, xuAchievement.y);
            xc += xuAchievement.x;
            yc += xuAchievement.y;
        }
        xc /= sort.size();
        yc /= sort.size();
        int scale = 2;
        char[][] chars = new char[(maxx - minx) * scale + 1][(maxy - miny) * scale + 1];
        for (XUAchievement achievement : sort) {
            int ch = 65;
            XUAchievement a = achievement.achParent;
            if (a != null) {
                char c;
                for (int dx = (Math.min(a.x, achievement.x) - minx) * scale; dx <= (Math.max(a.x, achievement.x) - minx) * scale; ++dx) {
                    c = chars[dx][(a.y - miny) * scale];
                    if (c == '\u0000') {
                        chars[dx][(a.y - miny) * scale] = 124;
                    }
                    if (c != '-') continue;
                    chars[dx][(a.y - miny) * scale] = 42;
                }
                for (int dy = (Math.min(a.y, achievement.y) - miny) * scale; dy <= (Math.max(a.y, achievement.y) - miny) * scale; ++dy) {
                    c = chars[(achievement.x - minx) * scale][dy];
                    if (c == '\u0000') {
                        chars[(achievement.x - minx) * scale][dy] = 45;
                    }
                    if (c != '|') continue;
                    chars[(achievement.x - minx) * scale][dy] = 42;
                }
                ch = (char)(ch + 1);
                while (a.achParent != null) {
                    a = a.achParent;
                    ch = (char)(ch + 1);
                }
            }
            chars[(achievement.x - minx) * scale][(achievement.y - miny) * scale] = ch;
        }
        StringBuilder builder = new StringBuilder();
        for (char[] aChar : chars) {
            builder.append('\n');
            for (char c : aChar) {
                builder.append(c);
            }
        }
        builder.append('\n');
        LogHelper.info(builder.toString(), new Object[0]);
        for (XUAchievement xuAchievement : sort) {
            String key = Lang.stripText(xuAchievement.name);
            String achKey = "achievement.xu2." + key;
            Lang.translate(achKey, xuAchievement.name);
            Lang.translate(achKey + ".desc", xuAchievement.description);
            Achievement parentAch = xuAchievement.achParent != null ? xuAchievement.achParent.achievement : null;
            ItemStack stack = xuAchievement.entry.newStack();
            if (stack == null) {
                stack = ItemIngredients.Type.SYMBOL_NOCRAFT.newStack();
            } else {
                dropMap.put((Object)ItemRef.wrap(stack), (Object)xuAchievement);
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    stack.func_77964_b(0);
                }
            }
            int y = xuAchievement.x - xc;
            int x = xuAchievement.y - yc;
            LogHelper.debug(achKey + " - " + (parentAch == null ? "[null]" : parentAch.func_150951_e().func_150260_c()), new Object[0]);
            Achievement achievement = new Achievement("achievement.xu2." + key, "xu2." + key, x, y, stack, parentAch);
            if (!built) {
                achievement.func_75971_g();
            }
            xuAchievement.achievement = achievement;
            achievements.add(achievement);
        }
        if (!built) {
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onPickup(PlayerEvent.ItemPickupEvent event) {
                    EntityItem pickedUp = event.pickedUp;
                    if (pickedUp == null) {
                        return;
                    }
                    AchievementHelper.checkForPotentialAwards(event.player, pickedUp.func_92059_d());
                }

                @SubscribeEvent
                public void onSmelt(PlayerEvent.ItemSmeltedEvent event) {
                    AchievementHelper.checkForPotentialAwards(event.player, event.smelting);
                }

                @SubscribeEvent
                public void onCraft(PlayerEvent.ItemCraftedEvent event) {
                    AchievementHelper.checkForPotentialAwards(event.player, event.crafting);
                }
            });
        }
        built = true;
    }

    public static void checkForPotentialAwards(EntityPlayer player, ItemStack stack) {
        if (stack == null || player == null) {
            return;
        }
        Set set = dropMap.get((Object)ItemRef.wrap(stack));
        if (!set.isEmpty()) {
            for (XUAchievement achievement : set) {
                player.func_71029_a((StatBase)achievement.achievement);
            }
        }
    }

    static {
        map = new HashMap();
        built = false;
        names = new HashSet();
    }

    private static class Layout {
        private Layout() {
        }

        public void buildTree() {
            TreeNode treeNode = new TreeNode(achievementChildren.get(null));
            treeNode.buildDepth();
            treeNode.assignValues(0, 0);
        }

        private static class TreeNode {
            public XUAchievement xuAchievement;
            public TIntArrayList minPoints = new TIntArrayList();
            public TIntArrayList maxPoints = new TIntArrayList();
            int shift;
            ArrayList<TreeNode> children = new ArrayList();

            public TreeNode(Collection<XUAchievement> xuChildren) {
                ArrayList<XUAchievement> list = new ArrayList<XUAchievement>(xuChildren);
                Collections.shuffle(list);
                for (XUAchievement achievement : list) {
                    this.children.add(new TreeNode(achievement));
                }
            }

            public TreeNode(XUAchievement xuAchievement) {
                this.xuAchievement = xuAchievement;
                ArrayList list = new ArrayList(achievementChildren.get((Object)xuAchievement));
                int n = list.size();
                if (n != 0) {
                    if (n == 1) {
                        this.children.add(new TreeNode(new TreeNode((XUAchievement)list.get(0))));
                    } else {
                        Collections.shuffle(list);
                        for (int i = 0; i < list.size(); ++i) {
                            int k = Math.min(i, list.size() - 1 - i);
                            XUAchievement achievement = (XUAchievement)list.get(i);
                            this.children.add(TreeNode.linkedChain(new TreeNode(achievement), k));
                        }
                    }
                }
            }

            public TreeNode(TreeNode child) {
                this.children.add(child);
            }

            public static TreeNode linkedChain(TreeNode child, int chain_length) {
                if (chain_length == 0) {
                    return child;
                }
                return new TreeNode(TreeNode.linkedChain(child, chain_length - 1));
            }

            void buildDepth() {
                int n = this.children.size();
                if (n == 0) {
                    this.minPoints.add(0);
                    this.maxPoints.add(0);
                } else if (n == 1) {
                    TreeNode child = this.children.get(0);
                    child.buildDepth();
                    this.minPoints.add(0);
                    this.maxPoints.add(0);
                    child.shift = 0;
                    this.minPoints.addAll((TIntCollection)child.minPoints);
                    this.maxPoints.addAll((TIntCollection)child.maxPoints);
                } else {
                    int midPoint;
                    int maxDepth = 0;
                    for (TreeNode child : this.children) {
                        child.buildDepth();
                        maxDepth = Math.max(Math.max(maxDepth, child.minPoints.size()), child.maxPoints.size());
                    }
                    int maxShift = 0;
                    for (int i = 1; i < n; ++i) {
                        TreeNode curChild = this.children.get(i);
                        curChild.shift = maxShift;
                        block2: while (true) {
                            ++curChild.shift;
                            for (int j = i - 1; j >= 0; --j) {
                                if (this.overlaps(this.children.get(j), curChild)) continue block2;
                            }
                            break;
                        }
                        maxShift = curChild.shift;
                    }
                    if (maxShift & true) {
                        midPoint = maxShift >> 1;
                        for (TreeNode child : this.children) {
                            if (child.shift <= midPoint) continue;
                            ++child.shift;
                        }
                        ++maxShift;
                    }
                    midPoint = maxShift >> 1;
                    for (TreeNode child : this.children) {
                        child.shift -= midPoint;
                    }
                    this.minPoints.add(this.children.get((int)0).shift);
                    this.maxPoints.add(this.children.get((int)(n - 1)).shift);
                    for (int i = 0; i < maxDepth; ++i) {
                        this.minPoints.add(0);
                        this.maxPoints.add(0);
                    }
                    for (TreeNode child : this.children) {
                        int x;
                        int i;
                        for (i = 0; i < child.minPoints.size(); ++i) {
                            x = child.shift + child.minPoints.get(i);
                            if (this.minPoints.get(i + 1) <= x) continue;
                            this.minPoints.set(i + 1, x);
                        }
                        for (i = 0; i < child.maxPoints.size(); ++i) {
                            x = child.shift + child.maxPoints.get(i);
                            if (this.maxPoints.get(i + 1) >= x) continue;
                            this.maxPoints.set(i + 1, x);
                        }
                    }
                }
            }

            public boolean overlaps(TreeNode left, TreeNode right) {
                int size = Math.min(left.maxPoints.size(), right.minPoints.size());
                for (int i = 0; i < size; ++i) {
                    int l_max = left.shift + left.maxPoints.get(i);
                    int r_min = right.shift + right.minPoints.get(i);
                    if (r_min > l_max) continue;
                    return true;
                }
                return false;
            }

            public void assignValues(int x, int y) {
                if (this.xuAchievement != null) {
                    this.xuAchievement.x = x;
                    this.xuAchievement.y = y;
                }
                for (TreeNode child : this.children) {
                    child.assignValues(x + child.shift, y + 1);
                }
            }
        }
    }

    public static class XUAchievement {
        public Achievement achievement;
        public String name;
        public String description;
        @Nonnull
        public IItemStackMaker entry;
        @Nullable
        public IItemStackMaker parent;
        public XUAchievement achParent;
        int x;
        int y;

        public XUAchievement(String name, String description, @Nonnull IItemStackMaker entry, @Nullable IItemStackMaker parent) {
            this.name = name;
            this.description = description;
            this.entry = entry;
            this.parent = parent;
        }

        public String toString() {
            return "XUAchievement{" + this.name + '}';
        }
    }
}

