/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameData;

public class ModIdentification {
    public static HashMap<String, String> modSource_Name = new HashMap();
    public static HashMap<String, String> modSource_ID = new HashMap();
    public static HashMap<Integer, String> itemMap = new HashMap();
    public static HashMap<String, String> keyhandlerStrings = new HashMap();

    public static void init() {
        for (ModContainer mod : Loader.instance().getModList()) {
            modSource_Name.put(mod.getSource().getName(), mod.getName());
            modSource_ID.put(mod.getSource().getName(), mod.getModId());
        }
        modSource_Name.put("1.6.2.jar", "Minecraft");
        modSource_Name.put("1.6.3.jar", "Minecraft");
        modSource_Name.put("1.6.4.jar", "Minecraft");
        modSource_Name.put("1.7.2.jar", "Minecraft");
        modSource_Name.put("1.8.0.jar", "Minecraft");
        modSource_Name.put("Forge", "Minecraft");
        modSource_ID.put("1.6.2.jar", "Minecraft");
        modSource_ID.put("1.6.3.jar", "Minecraft");
        modSource_ID.put("1.6.4.jar", "Minecraft");
        modSource_ID.put("1.7.2.jar", "Minecraft");
        modSource_ID.put("1.8.0.jar", "Minecraft");
        modSource_ID.put("1.8.8.jar", "Minecraft");
        modSource_ID.put("Forge", "Minecraft");
    }

    public static String nameFromObject(Object obj) {
        String objPath = obj.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        try {
            objPath = URLDecoder.decode(objPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String modName = "<Unknown>";
        for (String s : modSource_Name.keySet()) {
            if (!objPath.contains(s)) continue;
            modName = modSource_Name.get(s);
            break;
        }
        if (modName.equals("Minecraft Coder Pack")) {
            modName = "Minecraft";
        }
        return modName;
    }

    public static String nameFromStack(ItemStack stack) {
        try {
            ResourceLocation resource = (ResourceLocation)GameData.getItemRegistry().func_177774_c((Object)stack.func_77973_b());
            ModContainer mod = ModIdentification.findModContainer(resource.func_110624_b());
            String modName = mod == null ? "Minecraft" : mod.getName();
            return modName;
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public static ModContainer findModContainer(String modID) {
        for (ModContainer mc : Loader.instance().getModList()) {
            if (!modID.toLowerCase(Locale.US).equals(mc.getModId().toLowerCase(Locale.US))) continue;
            return mc;
        }
        return null;
    }
}

