/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.IWailaCommonAccessor;
import mcp.mobius.waila.api.IWailaTooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class DisplayUtil {
    private static FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
    protected static RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

    public static int getDisplayWidth(String s) {
        if (s == null || s.equals("")) {
            return 0;
        }
        int width = 0;
        Matcher renderMatcher = SpecialChars.patternRender.matcher(s);
        while (renderMatcher.find()) {
            IWailaTooltipRenderer renderer = ModuleRegistrar.instance().getTooltipRenderer(renderMatcher.group("name"));
            if (renderer == null) continue;
            width += renderer.getSize((String[])renderMatcher.group((String)"args").split((String)","), (IWailaCommonAccessor)DataAccessorCommon.instance).width;
        }
        Matcher iconMatcher = SpecialChars.patternIcon.matcher(s);
        while (iconMatcher.find()) {
            width += 8;
        }
        return width += fontRendererObj.func_78256_a(DisplayUtil.stripSymbols(s));
    }

    public static Dimension displaySize() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        return new Dimension(res.func_78326_a(), res.func_78328_b());
    }

    public static String stripSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternMinecraft.matcher(result).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static String stripWailaSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.enable3DRender();
        try {
            renderItem.func_180450_b(stack, x, y);
            renderItem.func_180453_a(fontRendererObj, stack, x, y, null);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            WailaExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float zLevel = 0.0f;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer t = tessellator.func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        t.func_181662_b((double)(left + right), (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        t.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        t.func_181662_b((double)left, (double)(top + bottom), (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        t.func_181662_b((double)(left + right), (double)(top + bottom), (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer t = tessellator.func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        t.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + th) * f1)).func_181675_d();
        t.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_181673_a((double)((float)(textureX + tw) * f), (double)((float)(textureY + th) * f1)).func_181675_d();
        t.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_181673_a((double)((float)(textureX + tw) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        t.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRendererObj.func_175063_a(text, (float)x, (float)y, colour);
        } else {
            fontRendererObj.func_78276_b(text, x, y, colour);
        }
    }

    public static List<String> itemDisplayNameMultiline(ItemStack itemstack) {
        ArrayList<String> namelist = null;
        try {
            namelist = itemstack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.size() == 0) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).equals("")) {
            namelist.set(0, "Unnamed");
        }
        namelist.set(0, itemstack.func_77953_t().field_77937_e.toString() + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, "\u00a77" + (String)namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        List<String> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return list.get(0);
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        if (icon == null) {
            return;
        }
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }
}

