/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.network.IWailaMessage;
import mcp.mobius.waila.network.Message0x02TENBTData;
import mcp.mobius.waila.network.WailaPacketHandler;
import mcp.mobius.waila.utils.AccessHelper;
import mcp.mobius.waila.utils.NBTUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class Message0x01TERequest
extends SimpleChannelInboundHandler<Message0x01TERequest>
implements IWailaMessage {
    private static Field classToNameMap = null;
    public int dim;
    public int posX;
    public int posY;
    public int posZ;
    public HashSet<String> keys = new HashSet();

    public Message0x01TERequest() {
    }

    public Message0x01TERequest(TileEntity ent, HashSet<String> keys) {
        this.dim = ent.func_145831_w().field_73011_w.func_177502_q();
        this.posX = ent.func_174877_v().func_177958_n();
        this.posY = ent.func_174877_v().func_177956_o();
        this.posZ = ent.func_174877_v().func_177952_p();
        this.keys = keys;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, IWailaMessage msg, ByteBuf target) throws Exception {
        target.writeInt(this.dim);
        target.writeInt(this.posX);
        target.writeInt(this.posY);
        target.writeInt(this.posZ);
        target.writeInt(this.keys.size());
        for (String key : this.keys) {
            WailaPacketHandler.INSTANCE.writeString(target, key);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf dat, IWailaMessage rawmsg) {
        try {
            Message0x01TERequest msg = (Message0x01TERequest)rawmsg;
            msg.dim = dat.readInt();
            msg.posX = dat.readInt();
            msg.posY = dat.readInt();
            msg.posZ = dat.readInt();
            int nkeys = dat.readInt();
            for (int i = 0; i < nkeys; ++i) {
                this.keys.add(WailaPacketHandler.INSTANCE.readString(dat));
            }
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, this.getClass().toString(), null);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message0x01TERequest msg) throws Exception {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = DimensionManager.getWorld((int)msg.dim);
        BlockPos pos = new BlockPos(msg.posX, msg.posY, msg.posZ);
        TileEntity entity = world.func_175625_s(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (entity != null) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                boolean hasNBTBlock = ModuleRegistrar.instance().hasNBTProviders(block);
                boolean hasNBTEnt = ModuleRegistrar.instance().hasNBTProviders(entity);
                if (hasNBTBlock || hasNBTEnt) {
                    tag.func_74768_a("x", msg.posX);
                    tag.func_74768_a("y", msg.posY);
                    tag.func_74768_a("z", msg.posZ);
                    tag.func_74778_a("id", (String)((HashMap)classToNameMap.get(null)).get(entity.getClass()));
                    EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
                    for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getNBTProviders(block).values()) {
                        for (IWailaDataProvider provider : providersList) {
                            try {
                                tag = provider.getNBTData(player, entity, tag, (World)world, new BlockPos(msg.posX, msg.posY, msg.posZ));
                            }
                            catch (AbstractMethodError ame) {
                                tag = AccessHelper.getNBTData(provider, entity, tag, (World)world, msg.posX, msg.posY, msg.posZ);
                            }
                            catch (NoSuchMethodError nsm) {
                                tag = AccessHelper.getNBTData(provider, entity, tag, (World)world, msg.posX, msg.posY, msg.posZ);
                            }
                        }
                    }
                    for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getNBTProviders(entity).values()) {
                        for (IWailaDataProvider provider : providersList) {
                            try {
                                tag = provider.getNBTData(player, entity, tag, (World)world, new BlockPos(msg.posX, msg.posY, msg.posZ));
                            }
                            catch (AbstractMethodError ame) {
                                tag = AccessHelper.getNBTData(provider, entity, tag, (World)world, msg.posX, msg.posY, msg.posZ);
                            }
                            catch (NoSuchMethodError nsm) {
                                tag = AccessHelper.getNBTData(provider, entity, tag, (World)world, msg.posX, msg.posY, msg.posZ);
                            }
                        }
                    }
                } else {
                    entity.func_145841_b(tag);
                    tag = NBTUtil.createTag(tag, msg.keys);
                }
                tag.func_74768_a("WailaX", msg.posX);
                tag.func_74768_a("WailaY", msg.posY);
                tag.func_74768_a("WailaZ", msg.posZ);
                tag.func_74778_a("WailaID", (String)((HashMap)classToNameMap.get(null)).get(entity.getClass()));
                WailaPacketHandler.INSTANCE.sendTo(new Message0x02TENBTData(tag), WailaPacketHandler.getPlayer(ctx));
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, entity.getClass().toString(), null);
            }
        }
    }

    static {
        try {
            classToNameMap = TileEntity.class.getDeclaredField("classToNameMap");
            classToNameMap.setAccessible(true);
        }
        catch (Exception e) {
            try {
                classToNameMap = TileEntity.class.getDeclaredField("field_145853_j");
                classToNameMap.setAccessible(true);
            }
            catch (Exception f) {
                throw new RuntimeException(f);
            }
        }
    }
}

