/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.inventory;

import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.inventory.SlotFurnaceOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerIronFurnace
extends Container {
    private FurnaceType type;
    private EntityPlayer player;
    private TileEntityIronFurnace furnace;
    private int[] lastCookTime;
    private int lastBurnTime = 0;
    private int lastItemBurnTime = 0;

    public ContainerIronFurnace(IInventory invPlayer, TileEntityIronFurnace invFurnace, FurnaceType type) {
        int x;
        int y;
        int i;
        this.furnace = invFurnace;
        this.player = ((InventoryPlayer)invPlayer).field_70458_d;
        this.type = type;
        this.lastCookTime = new int[type.parallelSmelting];
        int slotId = 0;
        for (i = 0; i < type.parallelSmelting; ++i) {
            this.func_75146_a(new Slot((IInventory)invFurnace, slotId++, type.mainInputX[i], type.mainInputY[i]));
            for (y = type.getNumInputRows() - 1; y >= 0; --y) {
                for (x = type.getInputSlotsPerRow() - 1; x >= 0; --x) {
                    this.func_75146_a(new Slot((IInventory)invFurnace, slotId++, type.inputX[i] + x * 18, type.inputY[i] + y * 18));
                }
            }
        }
        if (type.fuelSlots > 0) {
            this.func_75146_a((Slot)new SlotFurnaceFuel((IInventory)invFurnace, slotId++, type.mainFuelX, type.mainFuelY));
            for (int y2 = 0; y2 < type.getNumFuelRows(); ++y2) {
                for (int x2 = type.getFuelSlotsPerRow() - 1; x2 >= 0; --x2) {
                    this.func_75146_a(new Slot((IInventory)invFurnace, slotId++, type.fuelX + x2 * 18, type.fuelY + y2 * 18));
                }
            }
        }
        for (i = 0; i < type.parallelSmelting; ++i) {
            this.func_75146_a((Slot)new SlotFurnaceOutput(this.player, (IInventory)invFurnace, slotId++, type.mainOutputX[i], type.mainOutputY[i]));
            for (y = type.getNumOutputRows() - 1; y >= 0; --y) {
                for (x = 0; x < type.getOutputSlotsPerRow(); ++x) {
                    this.func_75146_a((Slot)new SlotFurnaceOutput(this.player, (IInventory)invFurnace, slotId++, type.outputX[i] + x * 18, type.outputY[i] + y * 18));
                }
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot(invPlayer, column + row * 9 + 9, type.inventoryX + column * 18, type.inventoryY + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot(invPlayer, column, type.inventoryX + column * 18, type.inventoryY + 58));
        }
    }

    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        icrafting.func_175173_a((Container)this, (IInventory)this.furnace);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (ICrafting var2 : this.field_75149_d) {
            for (int i = 0; i < this.type.parallelSmelting; ++i) {
                if (this.lastCookTime[i] == this.furnace.furnaceCookTime[i]) continue;
                var2.func_71112_a((Container)this, i, this.furnace.furnaceCookTime[i]);
            }
            if (this.lastBurnTime != this.furnace.furnaceBurnTime) {
                var2.func_71112_a((Container)this, this.type.parallelSmelting, this.furnace.furnaceBurnTime);
            }
            if (this.lastItemBurnTime == this.furnace.currentItemBurnTime) continue;
            var2.func_71112_a((Container)this, this.type.parallelSmelting + 1, this.furnace.currentItemBurnTime);
        }
        for (int i = 0; i < this.type.parallelSmelting; ++i) {
            this.lastCookTime[i] = this.furnace.furnaceCookTime[i];
        }
        this.lastBurnTime = this.furnace.furnaceBurnTime;
        this.lastItemBurnTime = this.furnace.currentItemBurnTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int i, int j) {
        if (i < this.type.parallelSmelting) {
            this.furnace.furnaceCookTime[i] = j;
        }
        if (i == this.type.parallelSmelting) {
            this.furnace.furnaceBurnTime = j;
        }
        if (i == this.type.parallelSmelting + 1) {
            this.furnace.currentItemBurnTime = j;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.furnace.func_70300_a(player);
    }

    private boolean isOutputSlot(int i) {
        return i >= this.type.getFirstOutputSlot(0) && i <= this.type.getLastOutputSlot(this.type.parallelSmelting - 1);
    }

    private boolean isInputSlot(int i) {
        return i >= this.type.getFirstInputSlot(0) && i <= this.type.getLastInputSlot(this.type.parallelSmelting - 1);
    }

    private boolean isFuelSlot(int i) {
        return i >= this.type.getFirstFuelSlot() && i <= this.type.getLastFuelSlot();
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            if (this.isOutputSlot(i)) {
                if (!this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 36, true)) {
                    return null;
                }
                slot.func_75220_a(stack1, stack);
            } else if (!this.isInputSlot(i) && !this.isFuelSlot(i) ? (FurnaceRecipes.func_77602_a().func_151395_a(stack1) != null ? !this.func_75135_a(stack1, 0, this.type.getFirstFuelSlot(), false) : (TileEntityIronFurnace.isItemFuel(stack1) ? !this.func_75135_a(stack1, this.type.getFirstFuelSlot(), this.type.getFirstOutputSlot(0), false) : (i >= this.type.getNumSlots() && i < this.type.getNumSlots() + 27 ? !this.func_75135_a(stack1, this.type.getNumSlots() + 27, this.type.getNumSlots() + 36, false) : i >= this.type.getNumSlots() + 27 && i < this.type.getNumSlots() + 36 && !this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 27, false)))) : !this.func_75135_a(stack1, this.type.getNumSlots(), this.type.getNumSlots() + 36, false)) {
                return null;
            }
            if (stack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (stack1.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stack1);
        }
        return stack;
    }
}

