/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces.blocks;

import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.MoreFurnaces;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMoreFurnaces
extends BlockContainer {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", FurnaceType.class);
    public static final PropertyEnum FACING = PropertyDirection.func_177706_a((String)"facing", EnumFacing.class, (Enum[])EnumFacing.field_176754_o);
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    private Random random;

    public BlockMoreFurnaces() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)FurnaceType.IRON)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("furnaceBlock");
        this.func_149711_c(2.5f);
        this.func_149672_a(Block.field_149777_j);
        this.random = new Random();
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public int func_149645_b() {
        return 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)FurnaceType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((FurnaceType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    protected BlockState func_180661_e() {
        IProperty[] listed = new IProperty[]{VARIANT, FACING, ACTIVE};
        return new BlockState((Block)this, listed);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = EnumFacing.NORTH;
        boolean active = false;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronFurnace) {
            TileEntityIronFurnace furnace = (TileEntityIronFurnace)te;
            facing = EnumFacing.values()[furnace.getFacing()];
            if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                facing = EnumFacing.NORTH;
            }
            active = furnace.isActive();
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return FurnaceType.makeEntity(meta);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronFurnace) {
            return ((TileEntityIronFurnace)te).isActive() ? 12 : 0;
        }
        return 0;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultDirection(world, pos, state);
        world.func_175689_h(pos);
    }

    private void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            Block block = world.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block block1 = world.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block block2 = world.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block block3 = world.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumFacing enumfacing = EnumFacing.SOUTH;
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j() && !block1.func_149730_j()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j() && !block.func_149730_j()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j() && !block3.func_149730_j()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j() && !block2.func_149730_j()) {
                enumfacing = EnumFacing.WEST;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof TileEntityIronFurnace) {
                ((TileEntityIronFurnace)te).setFacing((byte)enumfacing.func_176745_a());
                world.func_175689_h(pos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random random) {
        TileEntityIronFurnace tef;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityIronFurnace && (tef = (TileEntityIronFurnace)te).isActive()) {
            byte facing = tef.getFacing();
            float var7 = (float)pos.func_177958_n() + 0.5f;
            float var8 = (float)pos.func_177956_o() + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float var9 = (float)pos.func_177952_p() + 0.5f;
            float var10 = 0.52f;
            float var11 = random.nextFloat() * 0.6f - 0.3f;
            if (facing == 4) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0, new int[0]);
            } else if (facing == 5) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0, new int[0]);
            } else if (facing == 2) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0, new int[0]);
            } else if (facing == 3) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing facing, float f1, float f2, float f3) {
        FurnaceType type = (FurnaceType)((Object)state.func_177229_b((IProperty)VARIANT));
        if (type == FurnaceType.NETHERRACK && facing == EnumFacing.UP) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityIronFurnace)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)MoreFurnaces.instance, ((TileEntityIronFurnace)te).getType().ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        TileEntity te;
        byte furnaceFacing = 0;
        int facing = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            furnaceFacing = 2;
        }
        if (facing == 1) {
            furnaceFacing = 5;
        }
        if (facing == 2) {
            furnaceFacing = 3;
        }
        if (facing == 3) {
            furnaceFacing = 4;
        }
        if ((te = world.func_175625_s(pos)) != null && te instanceof TileEntityIronFurnace) {
            ((TileEntityIronFurnace)te).setFacing(furnaceFacing);
            world.func_175689_h(pos);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        for (FurnaceType type : FurnaceType.values()) {
            list.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        FurnaceType type = (FurnaceType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)VARIANT));
        return type == FurnaceType.NETHERRACK && side == EnumFacing.UP;
    }
}

