/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.multiblock;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameData;
import slimeknights.mantle.multiblock.IMasterLogic;
import slimeknights.mantle.multiblock.IServantLogic;

public class MultiServantLogic
extends TileEntity
implements IServantLogic {
    boolean hasMaster;
    BlockPos master;
    Block masterBlock;
    IBlockState state;

    public boolean canUpdate() {
        return false;
    }

    public boolean getHasMaster() {
        return this.hasMaster;
    }

    public boolean hasValidMaster() {
        if (!this.hasMaster) {
            return false;
        }
        if (this.field_145850_b.func_180495_p(this.master).func_177230_c() == this.masterBlock && this.field_145850_b.func_180495_p(this.master) == this.state) {
            return true;
        }
        this.hasMaster = false;
        this.master = null;
        return false;
    }

    @Override
    public BlockPos getMasterPosition() {
        return this.master;
    }

    public void overrideMaster(BlockPos pos) {
        this.hasMaster = true;
        this.master = pos;
        this.state = this.field_145850_b.func_180495_p(this.master);
        this.masterBlock = this.state.func_177230_c();
    }

    public void removeMaster() {
        this.hasMaster = false;
        this.master = null;
        this.masterBlock = null;
        this.state = null;
    }

    @Override
    public boolean setPotentialMaster(IMasterLogic master, World w, BlockPos pos) {
        return !this.hasMaster;
    }

    @Deprecated
    public boolean verifyMaster(IMasterLogic logic, BlockPos pos) {
        return this.master.equals((Object)pos) && this.field_145850_b.func_180495_p(pos) == this.state && this.field_145850_b.func_180495_p(pos).func_177230_c() == this.masterBlock;
    }

    @Override
    public boolean verifyMaster(IMasterLogic logic, World world, BlockPos pos) {
        if (this.hasMaster) {
            return this.hasValidMaster();
        }
        this.overrideMaster(pos);
        return true;
    }

    @Override
    public void invalidateMaster(IMasterLogic master, World w, BlockPos pos) {
        this.hasMaster = false;
        master = null;
    }

    @Override
    public void notifyMasterOfChange() {
        if (this.hasValidMaster()) {
            IMasterLogic logic = (IMasterLogic)this.field_145850_b.func_175625_s(this.master);
            logic.notifyChange(this, this.field_174879_c);
        }
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.hasMaster = tags.func_74767_n("hasMaster");
        if (this.hasMaster) {
            int xCenter = tags.func_74762_e("xCenter");
            int yCenter = tags.func_74762_e("yCenter");
            int zCenter = tags.func_74762_e("zCenter");
            this.master = new BlockPos(xCenter, yCenter, zCenter);
            this.masterBlock = (Block)GameData.getBlockRegistry().getObject(new ResourceLocation(tags.func_74779_i("MasterBlockName")));
            this.state = Block.func_176220_d((int)tags.func_74762_e("masterState"));
        }
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("hasMaster", this.hasMaster);
        if (this.hasMaster) {
            tags.func_74768_a("xCenter", this.master.func_177958_n());
            tags.func_74768_a("yCenter", this.master.func_177956_o());
            tags.func_74768_a("zCenter", this.master.func_177952_p());
            tags.func_74778_a("MasterBlockName", GameData.getBlockRegistry().getNameForObject((Object)this.masterBlock).toString());
            tags.func_74768_a("masterState", Block.func_176210_f((IBlockState)this.state));
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeCustomNBT(tags);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.field_145850_b.func_175679_n(this.field_174879_c);
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    @Deprecated
    public boolean setMaster(BlockPos pos) {
        if (!this.hasMaster || this.field_145850_b.func_180495_p(this.master) != this.state || this.field_145850_b.func_180495_p(this.master).func_177230_c() != this.masterBlock) {
            this.overrideMaster(pos);
            return true;
        }
        return false;
    }
}

